# -*- coding: utf-8 -*-
import sys
from os import path
sys.path.append(path.dirname(path.abspath(__file__)))
import argparse
from utils.utils import save_json_to_file
from works import CallCV
import json

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description="本地图像处理")
    parser.add_argument('-m', '--method', type=str, default='', help='方法名')
    parser.add_argument('-d', '--data', type=str, default='', help='参数')
    args = parser.parse_args()
    data_obj = {}
    if args.data != '':
        data_obj = json.loads(args.data)
    outputPath = ""
    callbackFileName = ""
    if "outputPath" in data_obj:
        outputPath = data_obj["outputPath"]
    if "callbackFileName" in data_obj:
        callbackFileName = data_obj["callbackFileName"]
    if args.method == '':
        parser.print_help()
        not_found_method = {"code": -3005, "msg": "not found function", "result": {}}
        save_json_to_file(not_found_method, path.join(outputPath, callbackFileName))
        sys.exit(1)
    result = CallCV(args.method, data_obj)
    save_json_to_file(result, path.join(outputPath, callbackFileName))
